using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

using Microsoft.Web.Services3;
using Microsoft.Web.Services3.Addressing;
using Microsoft.Web.Services3.Design;
using Microsoft.Web.Services3.Messaging;

using Microsoft.Samples.HttpSys;

namespace Consumer
{
    class Program
    {
        static void Main(string[] args)
        {
            if (args.Length != 2)
            {
                Console.WriteLine("Usage:");
                Console.WriteLine();
                Console.WriteLine("Consumer receiverUri serviceUri");
                Console.WriteLine();
                Console.WriteLine("receiverUri   The URI that the consumer will receive async callbacks on");
                Console.WriteLine("serviceUri    The URI that the service is accessible on");
                Console.WriteLine();
                Console.WriteLine("Example: Consumer http://localhost:52423/AsyncTestConsumer/ http://localhost:4333/Service.asmx");
                Console.WriteLine();
                return;
            }
            Program p = new Program();

            p.Run(new Uri(args[0]), new Uri(args[1]));

            Console.WriteLine("Press any key terminate..");
            Console.Read();
        }

        /// <summary>
        /// 
        /// </summary>
        private void Run(Uri receiverUri, Uri serviceUri)
        {
            //
            // Set up an http listener, to get this to work in WSE3, we use Aaron Skonnard's 
            // HTTP.SYS wrapper. In WCF/Indigo, the HTTP transport is already implemented and
            // the wrapper would not be needed if we were running in WCF/Indigo.
            //
            SoapReceivers.Add(new EndpointReference(receiverUri), 
                new WsdlEnabledReceiver(
                typeof(Consumer.AsyncTestConsumerReceiver)));

            //
            // Make the call a 100 times for testing purposes..
            //
            Console.WriteLine("Sending requests...");

            for (int i = 0; i < 100; i++)
            {
                Contract.Proxy.AsyncTestProviderSoapBinding theService =
                    new Contract.Proxy.AsyncTestProviderSoapBinding();

                Guid correlationId = Guid.NewGuid();

                theService.Destination = new EndpointReference(serviceUri);

                //
                // We need to create a custom policy to be able to set the
                // HTNG custom SOAP headers
                //
                Policy policy = new Policy();

                Contract.Policy.HtngSoapHeaderAssertion htngSoapHeaderAssertion =
                    new Contract.Policy.HtngSoapHeaderAssertion();

                policy.Assertions.Add(htngSoapHeaderAssertion);

                htngSoapHeaderAssertion.CorrelationID = correlationId.ToString("D");
                htngSoapHeaderAssertion.ReplyTo = receiverUri;
                htngSoapHeaderAssertion.FaultTo = receiverUri;

                theService.SetPolicy(policy);

                //
                // Make the actual call, this method will return immediately and
                // then we will get a callback to the AsyncTestConsumerReceiver
                // class when the async process has completed (successfully or
                // with a fault).
                //
                Contract.Proxy.CreateReservation_AsyncRequestInput input =
                    new Contract.Proxy.CreateReservation_AsyncRequestInput();

                input.FirstName = "John";
                input.LastName = "Doe";

                theService.CreateReservation_AsyncRequest(input);
            }

            Console.WriteLine("Sending requests... Done");
        }
    }
}
