using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

using Microsoft.Web.Services3;

namespace Contract.Policy
{
    /// <summary>
    /// A WSE3 SoapFilter implementation that emits the HTNG 2.0 async headers into 
    /// a SOAP envelope.
    /// </summary>
    public class HtngSoapHeaderOutputFilter : SoapFilter
    {
        private HtngSoapHeaderAssertion mAssertion;

        public const string HTNGCustomerHeaderNamespace = "urn:tobedetermined";

        public HtngSoapHeaderOutputFilter(HtngSoapHeaderAssertion assertion)
        {
            mAssertion = assertion;
        }

        public override SoapFilterResult ProcessMessage(SoapEnvelope envelope)
        {
            //
            // Add headers
            //
            if(mAssertion.CorrelationID != null)
                envelope.Header.AppendChild(CreateHTNGHeader(envelope, "CorrelationID", mAssertion.CorrelationID));
            
            if(mAssertion.ReplyTo != null)
                envelope.Header.AppendChild(CreateHTNGHeader(envelope, "ReplyTo", mAssertion.ReplyTo.ToString()));

            if(mAssertion.FaultTo != null)
                envelope.Header.AppendChild(CreateHTNGHeader(envelope, "FaultTo", mAssertion.FaultTo.ToString()));

            if (mAssertion.RelatesToCorrelationID != null)
                envelope.Header.AppendChild(CreateHTNGHeader(envelope, "RelatesToCorrelationID", 
                    mAssertion.RelatesToCorrelationID.ToString()));

            return SoapFilterResult.Continue;
        }

        private XmlElement CreateHTNGHeader(SoapEnvelope envelope, string name, string value)
        {
            XmlElement elem = envelope.CreateElement(name, HTNGCustomerHeaderNamespace);
            elem.InnerText = value;
            return elem;
        }

    }
}
