using System;
using System.Data;
using System.Diagnostics;
using System.Web;
using System.Collections;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.ComponentModel;
using System.Threading;
using System.Xml;

using Microsoft.Web.Services3;
using Microsoft.Web.Services3.Design;

namespace Provider
{
    /// <summary>
    /// Implementation of the AsyncTest provider. Regular ASMX Web Service.
    /// </summary>
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    public class Service : System.Web.Services.WebService, Contract.Service.IAsyncTestProviderSoapBinding
    {
        private class CompletionArgs
        {
            public Contract.Service.CreateReservation_AsyncRequestInput Request;
            public Uri ReplyTo;
            public Uri FaultTo;
            public string CorrelationId;

            public CompletionArgs(
                Contract.Service.CreateReservation_AsyncRequestInput request,
                Uri replyTo, Uri faultTo, string correlationId)
            {
                Request = request;
                ReplyTo = replyTo;
                FaultTo = faultTo;
                CorrelationId = correlationId;
            }
        }

        public SoapUnknownHeader[] UnknownHeaders;

        [SoapHeader("UnknownHeaders")]
        public Contract.Service.CreateReservation_AsyncRequestOutput CreateReservation_AsyncRequest(
            Contract.Service.CreateReservation_AsyncRequestInput createReservation_AsyncRequestInput)
        {
            //
            // Extract HTNG specific async headers
            //
            string correlationId = null, replyTo = null, faultTo = null;

            if (UnknownHeaders != null)
            {
                foreach (SoapUnknownHeader header in UnknownHeaders)
                {
                    if (header.Element.NamespaceURI == "urn:tobedetermined")
                    {
                        switch (header.Element.LocalName)
                        {
                            case "CorrelationID":
                                correlationId = header.Element.InnerText;
                                break;

                            case "ReplyTo":
                                replyTo = header.Element.InnerText;
                                break;

                            case "FaultTo":
                                faultTo = header.Element.InnerText;
                                break;
                        }
                    }
                }
            }

            if (faultTo == null)
                // Use htng:ReplyTo instead
                faultTo = replyTo;

            //
            // Make sure we have values for CorrelationID and ReplyTo
            //
            if (correlationId == null)
                throw new SoapException("CorrelationID header is missing",
                    SoapException.ClientFaultCode);

            if (replyTo == null)
                throw new SoapException("ReplyTo header is missing",
                    SoapException.ClientFaultCode);

            //
            // Simulate an asynchronous process by kicking off a separate 
            // thread to respond with a fault or success.
            // 
            ThreadPool.QueueUserWorkItem(SendAsyncResult, 
                new CompletionArgs(
                createReservation_AsyncRequestInput,
                new Uri(replyTo),
                new Uri(faultTo),
                correlationId));

            //
            // Return the "void" value.
            //
            return new Contract.Service.CreateReservation_AsyncRequestOutput();
        }

        /// <summary>
        /// This method will be called in another thread and is used to simulate the
        /// asynchronous process that will return a success or fail once it is complete.
        /// </summary>
        /// <param name="arg"></param>
        private void SendAsyncResult(object arg)
        {
            CompletionArgs completionArgs = (CompletionArgs)arg;

            //
            // Sleep for a bit to simulate some sort of lenghty process
            //
            Random random = new Random();
            Thread.Sleep(random.Next(2000));

            Contract.Proxy.AsyncTestConsumerSoapBinding consumer =
                new Contract.Proxy.AsyncTestConsumerSoapBinding();

            //
            // We need to create a custom policy to be able to set the
            // HTNG custom SOAP headers
            //
            Policy policy = new Policy();

            Contract.Policy.HtngSoapHeaderAssertion htngSoapHeaderAssertion =
                new Contract.Policy.HtngSoapHeaderAssertion();

            policy.Assertions.Add(htngSoapHeaderAssertion);

            htngSoapHeaderAssertion.RelatesToCorrelationID = completionArgs.CorrelationId;

            consumer.SetPolicy(policy);

            //
            // Randomly return a success or a fault
            //
            try
            {
                if (random.Next(2) == 0)
                {
                    //
                    // Return success
                    //
                    consumer.Destination = new Microsoft.Web.Services3.Addressing.EndpointReference(
                        completionArgs.ReplyTo);

                    Contract.Proxy.CreateReservation_AsyncResponseInput response =
                        new Contract.Proxy.CreateReservation_AsyncResponseInput();

                    response.ConfirmationNumber = "ABC12345";

                    consumer.CreateReservation_AsyncResponse(response);
                }
                else
                {
                    //
                    // Return a fault
                    //
                    consumer.Destination = new Microsoft.Web.Services3.Addressing.EndpointReference(
                        completionArgs.FaultTo);

                    // Create a SoapException
                    Soap12 wseSoap12Helper = new Soap12();
                    XmlDocument doc = new XmlDocument();

                    XmlElement detail = doc.CreateElement("Detail", wseSoap12Helper.NamespaceURI);

                    // TODO: Populate the <Detail> element if this is a fault that is declared
                    // ahead of time and well-defined, e.g. in the WSDL and XML Schema
                    detail.AppendChild(doc.CreateElement("TheWellKnownExceptionDetail", "urn:foo"));

                    SoapException soapException = new SoapException("Something went wrong, etc, etc..",
                        WseSoapHeaderException.ServerFaultCode, "", detail);

                    XmlElement methodElement = doc.CreateElement("CreateReservation_AsyncFaultInput",
                        "http://htng.org/PWSWG/2006/08/Framework20/AsyncTest");

                    methodElement.AppendChild(
                        wseSoap12Helper.GetFaultXml(doc, soapException, null));

                    // Send back the actual fault
                    consumer.CreateReservation_AsyncFault(methodElement);
                }
            }
            catch (Exception ex)
            {
                //
                // We cannot rethrow the exception here so just log it..
                //
                EventLog.WriteEntry("HTNG.Provider.Service", ex.ToString());
            }
        }
    }
}
