//
// Written by Aaron Skonnard (aaron@pluralsight.com)
// Blog: http://pluralsight.com/aaron/ 
//

using System;
using System.Net;
using System.Xml;
using Microsoft.Web.Services3;
using Microsoft.Web.Services3.Addressing;
using Microsoft.Web.Services3.Messaging;

namespace Microsoft.Samples.HttpSys
{
    //
    // In WSE, ISoapOutputChannel manages the conversation between a receiver
    // (e.g., an instance of an ASMX class) and an the network (e.g., HTTP.SYS). 
    //
    // After dispatching the message, SoapReceivers calls Send to transmit the 
    // response back to the original sender. Most of the functionality needed is 
    // provided by the SoapOutputChannel implementation, our base class here.
    //
	public class HttpSysOutputChannel : SoapOutputChannel
	{
        //
        // The supplied EndpointReference identifies the original sender in this case.
        //
        public HttpSysOutputChannel(EndpointReference epr)
            : base(epr)
		{
		}

        // 
        // Called by SoapReceivers infrastructure to transmit response back to
        // the client
        //
		public override void Send(SoapEnvelope message)
		{
            //
            // The HttpSysAdapter stores the HttpListenerContext in the message state
            // so we can easily look it up to transmit the response
            //
            HttpListenerContext context = message.Context.SessionState.Get<HttpListenerContext>("HttpSysAdapter");
            if (context == null)
                throw new Exception("HttpListenerContext unavailable in HttpSysOutputChannel.Send");

            // Transmit SoapEnvelope back to client
            context.Response.ContentType = "text/xml";
            using (XmlTextWriter tw = new XmlTextWriter(context.Response.OutputStream, System.Text.Encoding.UTF8))
            {
                message.WriteTo(tw);
            }
        }
	}
}
