using System;

using Microsoft.Web.Services3;
using Microsoft.Web.Services3.Design;
using Microsoft.Web.Services3.Security;

namespace HTNG.Web.Services2.Design
{
    /// <summary>
    /// Custom Policy used to indicate the header and action
    /// requirements for an HTNG 2.0 Framework SOAP message 
    /// exchange.  This class is an alternative to configuring
    /// a service Policy via configuration file at runtime.
    /// </summary>
    public class HTNGBasePolicy : Policy
    {
        /// <summary>
        /// Custom constructor calls the base constructor, then adds
        /// two additional PolicyAssertions.  For purposes of HTNG 2.0 
        /// framework, the required assertions are:
        /// <para><i>UsernameOverTransportAssertion</i>, which represents a turnkey 
        /// security assertion that authenticates the client using a 
        /// UsernameToken security token. The SOAP message is not 
        /// encrypted or digitally signed so username and password
        /// pairs are plaintext.</para>
        /// <para><i>RequireActionHeaderAssertion</i>, which represents a 
        /// security assertion that requires the presence of the Action 
        /// header for the ultimate recipient of SOAP requests sent 
        /// to a Web service. </para>
        /// </summary>
        public HTNGBasePolicy()
            : base()
        {
            UsernameOverTransportAssertion usernameOverTranportAssertion = 
                new UsernameOverTransportAssertion();
            this.Assertions.Add(usernameOverTranportAssertion);

            RequireActionHeaderAssertion requireActionHeaderAssertion = 
                new RequireActionHeaderAssertion();
            this.Assertions.Add(requireActionHeaderAssertion);
        }
    }
}
