using System;
using System.Collections.Generic;
using System.Text;
using System.Web.Services.Protocols;
using System.Web.Services;
using System.Xml;

using Microsoft.Web.Services3;
using Microsoft.Web.Services3.Design;

namespace Consumer
{
    /// <summary>
    /// Class used as the receiver of the asynchronous callback events.
    /// </summary>
    [WebService(Name = "AsyncTestConsumer", Namespace = "http://htng.org/PWSWG/2006/08/Framework20/AsyncTest")]
    public class AsyncTestConsumerReceiver : Contract.Service.IAsyncTestConsumerSoapBinding
    {
        /// <summary>
        /// This will contain all the unknown SOAP headers in the incoming message, 
        /// we need this in order to be able to extract the HTNG headers.
        /// </summary>
        public SoapUnknownHeader[] UnknownHeaders;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="createReservation_AsyncResponseInput"></param>
        /// <returns></returns>
        [SoapHeader("UnknownHeaders")]
        public Contract.Service.CreateReservation_AsyncResponseOutput 
            CreateReservation_AsyncResponse(
            Contract.Service.CreateReservation_AsyncResponseInput createReservation_AsyncResponseInput)
        {
            // Get the correlation id so that we can correlate this message to the 
            // original request message
            string relatesToCorrelationId = GetHTNGHeader("RelatesToCorrelationID");

            // TODO: Do something useful with the response message.. Simply log it to
            // the console for now..
            Console.WriteLine(string.Format(
                "Got a success message that relates to correlation id {0}, the confirmation number is {1}.", 
                relatesToCorrelationId,
                createReservation_AsyncResponseInput.ConfirmationNumber));

            // We need to return a "void" value to the server to indicate that we 
            // successfully processed the async response
            return new Contract.Service.CreateReservation_AsyncResponseOutput();
        }


        /// <summary>
        /// 
        /// </summary>
        /// <param name="createReservation_AsyncFaultInput"></param>
        /// <returns></returns>
        [SoapHeader("UnknownHeaders")]
        public Contract.Service.CreateReservation_AsyncFaultOutput
            CreateReservation_AsyncFault(System.Xml.XmlElement createReservation_AsyncFaultInput)
        {
            // Get the correlation id so that we can correlate this message to the 
            // original request message
            string relatesToCorrelationId = GetHTNGHeader("RelatesToCorrelationID");

            //
            // Ask WSE to convert the Fault XML to a SoapException. This will work with
            // both SOAP 1.1 and SOAP 1.2.
            //
            SoapException soapException = GetSoapExceptionFromFaultXml(
                createReservation_AsyncFaultInput);

            //
            // TODO: Handle the exception. Compare the element QName in the Detail to
            // fault types that are known ahead of time (e.g. declare in the WSDL).
            // For now we simply log it to the console..
            //
            Console.WriteLine(string.Format(
                "Got a fault message that relates to correlation id {0}",
                relatesToCorrelationId));

            // Hand back the "void" result to indicate that we have successfully received
            // the fault 
            return new Contract.Service.CreateReservation_AsyncFaultOutput();
        }

        /// <summary>
        /// Use WSE to convert an XML representation of a Fault to an instance of a
        /// SoapException class. Supports SOAP 1.1 and 1.2 formatted faults.
        /// </summary>
        /// <param name="xml"></param>
        /// <returns></returns>
        private SoapException GetSoapExceptionFromFaultXml(XmlElement xml)
        {
            Soap11 soap11 = new Soap11();
            Soap12 soap12 = new Soap12();

            if (xml.NamespaceURI == soap11.NamespaceURI)
                return (SoapException) soap11.FromFaultXml(xml);

            else if (xml.NamespaceURI == soap12.NamespaceURI)
                return (SoapException) soap12.FromFaultXml(xml);

            else
                throw new ApplicationException("Unknown fault namespace, " + 
                    "we only support SOAP 1.1 and 1.2");
        }

        /// <summary>
        /// Retrieve the value of an HTNG header with the given name.
        /// </summary>
        /// <param name="headerName"></param>
        /// <returns></returns>
        private string GetHTNGHeader(string headerName)
        {
            if (UnknownHeaders == null)
                return null;

            foreach (SoapUnknownHeader soapUnknownHeader in UnknownHeaders)
            {
                if (soapUnknownHeader.Element.LocalName == headerName &&
                    soapUnknownHeader.Element.NamespaceURI ==
                    Contract.Policy.HtngSoapHeaderOutputFilter.HTNGCustomerHeaderNamespace)
                    return soapUnknownHeader.Element.InnerText;
            }

            return null;
        }
    }
}
