using System;
using System.Collections.Generic;
using System.Text;

using Microsoft.Web.Services3.Design;

namespace Contract.Policy
{
    /// <summary>
    /// WSE3 PolicyAssertion implementation that is used in order to be able to
    /// emit the HTNG Framework 2.0 Async headers.
    /// </summary>
    public class HtngSoapHeaderAssertion : PolicyAssertion
    {
        private string mCorrelationID;
        private string mRelatesToCorrelationID;
        private Uri mReplyTo;
        private Uri mFaultTo;

        public string CorrelationID
        {
            get
            {
                return mCorrelationID;
            }
            set
            {
                mCorrelationID = value;
            }
        }

        public string RelatesToCorrelationID
        {
            get
            {
                return mRelatesToCorrelationID;
            }
            set
            {
                mRelatesToCorrelationID = value;
            }
        }

        public Uri ReplyTo
        {
            get
            {
                return mReplyTo;
            }
            set
            {
                mReplyTo = value;
            }
        }

        public Uri FaultTo
        {
            get
            {
                return mFaultTo;
            }
            set
            {
                mFaultTo = value;
            }
        }
        
        public override Microsoft.Web.Services3.SoapFilter CreateClientInputFilter(FilterCreationContext context)
        {
            return null;
        }

        public override Microsoft.Web.Services3.SoapFilter CreateClientOutputFilter(FilterCreationContext context)
        {
            return new HtngSoapHeaderOutputFilter(this);
        }

        public override Microsoft.Web.Services3.SoapFilter CreateServiceInputFilter(FilterCreationContext context)
        {
            return null;
        }

        public override Microsoft.Web.Services3.SoapFilter CreateServiceOutputFilter(FilterCreationContext context)
        {
            return null;
        }
    }
}
