using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Security.Permissions;
using System.Xml;
using Microsoft.Web.Services3;
using Microsoft.Web.Services3.Design;
using Microsoft.Web.Services3.Security;
using Microsoft.Web.Services3.Security.Tokens;

// define a custom policy that will require the presense of
// the UsernameToken and Action headers in SOAP requests
public class ActivityServicePolicy : Policy
{
  public ActivityServicePolicy()
    : base()
  {
    // Create a new instance of the UsernameOverTransportAssertion turnkey security assertion.
    UsernameOverTransportAssertion userAssertion = new UsernameOverTransportAssertion();
    // Create a new instance of the RequireActionHeaderAssertion turnkey security assertion.
    RequireActionHeaderAssertion actionAssertion = new RequireActionHeaderAssertion();
    // Add the assertions to the policy
    this.Assertions.Add(userAssertion);
    this.Assertions.Add(actionAssertion);
  }
}

// to implement a custom authentication mechanism,
// define a custom username token manager class 
// and add it to web.config (see the <securityTokenManager> section)
[SecurityPermissionAttribute(SecurityAction.Demand, Flags = SecurityPermissionFlag.UnmanagedCode)]
public class AuthenticationManager : UsernameTokenManager
{
  public AuthenticationManager() : base() { }
  public AuthenticationManager(XmlNodeList configData) : base(configData) { }

  // override this method to implement custom authentication
  protected override string AuthenticateToken(UsernameToken token)
  {
    // In case passwords are stored in the form of a digest, 
    // both the username and password must be validated, 
    // and the supplied token.Password must be returned if successful
    /*
    if(token.Username == "SMS" && token.Password == "sns")
      return token.Password;
    else // if failed - throw a SecurityFault exception
      throw new SecurityFault("Access denied : Invalid logon credentials supplied");
    */

    // If passwords are stored in clear text, 
    // validate the username and return stored password.
    // Password validation will then be performed by WSE
    switch (token.Username)
    {
      case "AAA": return "aaa";
      case "BBB": return "bbb";
      case "CCC": return "ccc";
      default: return "";
    }
  }
}
