﻿using System;
using System.Collections.Generic;
using System.Text;

using Contract.Client;
using Faults = Contract.Client.Faults;

namespace ClientConsoleApplication
{
    class Program
    {
        static void Main(string[] args)
        {
            MathService m = new MathService();
            
            m.Url = "http://localhost/HTNG/Framework/Fault handling/Example/ServiceHostedInIIS/Service.asmx";

            //
            // Try a normal Add first that will not throw an exception
            //
            Console.WriteLine("1 + 2 is " + m.Add(1, 2));

            //
            // Try various forms of the "Add" method that will throw the custom 
            // "ArithmeticOverflowFaultException" exception
            //
            try
            {
                m.Add(int.MaxValue, 1);
            }
            catch (Faults.ArithmeticOverflowFaultException ex)
            {
                Faults.ArithmeticOverflowFault fault = ex.TypedDetail;

                Console.WriteLine(string.Format(
                    "Overflow, lower bound {0} upper bound {1}",
                    fault.LowerBound, fault.UpperBound));
            }

            try
            {
                IAsyncResult asyncResult = m.BeginAdd(int.MaxValue, 1, null, null);
                m.EndAdd(asyncResult);
            }
            catch (Faults.ArithmeticOverflowFaultException ex)
            {
                Faults.ArithmeticOverflowFault fault = ex.TypedDetail;

                Console.WriteLine(string.Format(
                    "Overflow, lower bound {0} upper bound {1}",
                    fault.LowerBound, fault.UpperBound));
            }

            try
            {
                m.AddCompleted += new AddCompletedEventHandler(m_AddCompleted);
                m.AddAsync(int.MaxValue, 1);
            }
            catch (Faults.ArithmeticOverflowFaultException ex)
            {
                Faults.ArithmeticOverflowFault fault = ex.TypedDetail;

                Console.WriteLine(string.Format(
                    "Overflow, lower bound {0} upper bound {1}",
                    fault.LowerBound, fault.UpperBound));
            }

            //
            // And give "Divide" a try as well to generate the "DivideByZeroFaultException" 
            // exception
            //
            try
            {
                m.Divide(10, 0);
            }
            catch (Faults.DivideByZeroFaultException)
            {
                Console.WriteLine("Divide by zero");
            }

            Console.WriteLine("Done, press any key to terminate");
            Console.ReadLine();

        }

        static void m_AddCompleted(object sender, AddCompletedEventArgs e)
        {
            if (e.Error is Faults.ArithmeticOverflowFaultException)
            {
                Faults.ArithmeticOverflowFaultException arithmeticOverflowFaultException =
                    (Faults.ArithmeticOverflowFaultException)e.Error;

                Console.WriteLine(string.Format("AddCompleted callback: Overflow exception, " + 
                    "lower bound {0} upper bound {1}", 
                    arithmeticOverflowFaultException.TypedDetail.LowerBound,
                    arithmeticOverflowFaultException.TypedDetail.UpperBound));
            }
            else if(e.Error == null)
                Console.WriteLine("AddCompleted callback: Add completed successfully");
            else
                Console.WriteLine("AddCompleted callback: Unknown exception");
        }
    }
}
