using System;
using System.Collections.Generic;
using System.Text;

using Microsoft.Web.Services3;
using Microsoft.Web.Services3.Design;
using Microsoft.Web.Services3.Security;
using Microsoft.Web.Services3.Security.Tokens;

using HTNG.Web.Samples.Client.Math;

namespace HTNG.Web.Samples.Client
{
    public class MathClient
    {
        private MathServiceWse _service;
        
        public MathClient( string username, string password )
        {
            _service = new MathServiceWse();

            UsernameOverTransportAssertion usernameOverTransportAssertion = 
                new UsernameOverTransportAssertion();
            usernameOverTransportAssertion.UsernameTokenProvider = 
                new UsernameTokenProvider( username, password );

            Policy policy = new Policy();
            policy.Assertions.Add(usernameOverTransportAssertion);

            _service.SetPolicy(policy);
        }

        public int Add(int a, int b)
        {
            return _service.Add(a, b);
        }

        public int Subtract (int a, int b)
        {
            return _service.Subtract(a, b);
        }

        public int Multiply(int a, int b)
        {
            return _service.Multiply(a, b);
        }

        public double Divide(int a, int b)
        {
            return _service.Divide(a, b);
        }
    }

    class Program
    {
        private static char[] actions = new char[] { '+', '-', '*', '/' };

        #region Helper Methods

        private static void Usage()
        {
            Console.WriteLine ( "usage: c<a,b>" );
            Console.WriteLine ( "  c: action character in +,-,*,/,Q ");
            Console.WriteLine ( "  a: integer value" );
            Console.WriteLine ( "  b: integer value" );
        }

        private static bool GetBits(string input, out int a, out int b)
        {
            a = 0; b = 0;
            string[] bits = input.Substring(1).Split(new char[] { ',' });
            try
            {
                a = Convert.ToInt32(bits[0]);
                b = Convert.ToInt32(bits[1]);
                return true;
            }
            catch
            {
                Usage();
                return false;
            }
        }

        private static bool ValidAction(string input)
        {
            bool result = input != null && 
                input.Length > 0 && 
                Array.IndexOf(actions, input[0]) >= 0;
            if ( !result )
            {
                Usage();
            }
            return result;
        }

        #endregion

        static void Main(string[] args)
        {
            // ANY combination of username and password
            // will pass authentication EXCEPT a username
            // of "INVALID".  Passing "INVALID" as a username
            // with any password will throw a SecurityFault
            // with message "ACCESS DENIED".
            MathClient _client = new MathClient("any", "value");
            
            while ( true )
            {
                string input = Console.ReadLine();

                if (input == "Q")
                    break;

                if ( !ValidAction( input ) )
                    continue;

                int a; int b;

                if (!GetBits(input, out a, out b))
                    continue;

                switch ( input[0] )     
                {
                    case '+' :
                        Console.WriteLine(_client.Add(a, b));
                        break;
                    case '-' :
                        Console.WriteLine(_client.Subtract(a, b));
                        break;
                    case '*' :
                        Console.WriteLine(_client.Multiply(a, b));
                        break;
                    case (char)0x2F :
                        Console.WriteLine(_client.Divide(a, b));
                        break;
                    default :
                        Usage();
                        break;
                }
            }
        }
    }
}
