using System;
using System.Web;
using System.Web.Services;

using Microsoft.Web.Services3;
using HTNG.Web.Services2.Design;

namespace HTNG.Web.Samples.Math
{
    [WebService(Namespace = "http://htng.org/PSWG/06/04/Samples/Math")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    // Note the application of the HTNGBasePolicy
    // via type. This could also be done via 
    // policy file. 
    [Policy(typeof(HTNGBasePolicy))]
    public class MathService : System.Web.Services.WebService
    {
        public MathService()
        {
            //
        }

        [WebMethod(Description = "Add to integers (a + b).")]
        public int Add(int a, int b)
        {
            return a + b;
        }

        [WebMethod(Description = "Subtract to integer (a - b).")]
        public int Subtract(int a, int b)
        {
            return a - b;
        }

        [WebMethod(Description = "Multiply two integers (a * b).")]
        public int Multiply(int a, int b)
        {
            return a * b;
        }

        [WebMethod(Description = "Divide two integers (a / b).")]
        public Double Divide(int a, int b)
        {
            return Convert.ToDouble(a) / Convert.ToDouble(b);
        }
    }
}
