namespace Contract.Client.Faults {
    
    
    public class ArithmeticOverflowFaultException : System.Web.Services.Protocols.SoapException {
        
        public ArithmeticOverflowFaultException(string message, System.Xml.XmlQualifiedName code, string actor, Contract.Client.Faults.ArithmeticOverflowFault detail) : 
                base(message, code, actor, ArithmeticOverflowFaultException.SerializeTypeToXml(detail)) {
        }
        
        public ArithmeticOverflowFaultException(string message, System.Xml.XmlQualifiedName code, string actor, System.Xml.XmlNode detail) : 
                base(message, code, actor, detail) {
        }
        
        public ArithmeticOverflowFaultException(System.Xml.XmlQualifiedName code, Contract.Client.Faults.ArithmeticOverflowFault detail) : 
                this("An exception occurred", code, "", detail) {
        }
        
        public virtual Contract.Client.Faults.ArithmeticOverflowFault TypedDetail {
            get {
                System.Xml.XmlElement detail = ((System.Xml.XmlElement)(base.Detail.FirstChild));
                System.Xml.Serialization.XmlSerializer xmlSerializer = new System.Xml.Serialization.XmlSerializer(typeof(Contract.Client.Faults.ArithmeticOverflowFault));
                return ((Contract.Client.Faults.ArithmeticOverflowFault)(xmlSerializer.Deserialize(new System.Xml.XmlNodeReader(detail))));
            }
        }
        
        public static System.Xml.XmlElement SerializeTypeToXml(Contract.Client.Faults.ArithmeticOverflowFault detail) {
            System.Xml.Serialization.XmlSerializer xmlSerializer = new System.Xml.Serialization.XmlSerializer(typeof(Contract.Client.Faults.ArithmeticOverflowFault));
            System.IO.MemoryStream ms = new System.IO.MemoryStream();
            xmlSerializer.Serialize(ms, detail);
            ms.Seek(0, System.IO.SeekOrigin.Begin);
            System.Xml.XmlDocument xmlDoc = new System.Xml.XmlDocument();
            xmlDoc.Load(ms);
            System.Xml.XmlElement rootDetail = ((System.Xml.XmlElement)(xmlDoc.CreateNode(System.Xml.XmlNodeType.Element, System.Web.Services.Protocols.SoapException.DetailElementName.Name, System.Web.Services.Protocols.SoapException.DetailElementName.Namespace)));
            rootDetail.AppendChild(xmlDoc.RemoveChild(xmlDoc.DocumentElement));
            return rootDetail;
        }
    }
    
    public class DivideByZeroFaultException : System.Web.Services.Protocols.SoapException {
        
        public DivideByZeroFaultException(string message, System.Xml.XmlQualifiedName code, string actor, Contract.Client.Faults.DivideByZeroFault detail) : 
                base(message, code, actor, DivideByZeroFaultException.SerializeTypeToXml(detail)) {
        }
        
        public DivideByZeroFaultException(string message, System.Xml.XmlQualifiedName code, string actor, System.Xml.XmlNode detail) : 
                base(message, code, actor, detail) {
        }
        
        public DivideByZeroFaultException(System.Xml.XmlQualifiedName code, Contract.Client.Faults.DivideByZeroFault detail) : 
                this("An exception occurred", code, "", detail) {
        }
        
        public virtual Contract.Client.Faults.DivideByZeroFault TypedDetail {
            get {
                System.Xml.XmlElement detail = ((System.Xml.XmlElement)(base.Detail.FirstChild));
                System.Xml.Serialization.XmlSerializer xmlSerializer = new System.Xml.Serialization.XmlSerializer(typeof(Contract.Client.Faults.DivideByZeroFault));
                return ((Contract.Client.Faults.DivideByZeroFault)(xmlSerializer.Deserialize(new System.Xml.XmlNodeReader(detail))));
            }
        }
        
        public static System.Xml.XmlElement SerializeTypeToXml(Contract.Client.Faults.DivideByZeroFault detail) {
            System.Xml.Serialization.XmlSerializer xmlSerializer = new System.Xml.Serialization.XmlSerializer(typeof(Contract.Client.Faults.DivideByZeroFault));
            System.IO.MemoryStream ms = new System.IO.MemoryStream();
            xmlSerializer.Serialize(ms, detail);
            ms.Seek(0, System.IO.SeekOrigin.Begin);
            System.Xml.XmlDocument xmlDoc = new System.Xml.XmlDocument();
            xmlDoc.Load(ms);
            System.Xml.XmlElement rootDetail = ((System.Xml.XmlElement)(xmlDoc.CreateNode(System.Xml.XmlNodeType.Element, System.Web.Services.Protocols.SoapException.DetailElementName.Name, System.Web.Services.Protocols.SoapException.DetailElementName.Namespace)));
            rootDetail.AppendChild(xmlDoc.RemoveChild(xmlDoc.DocumentElement));
            return rootDetail;
        }
    }
    
    public class FaultExceptionMapper : ExceptionHelper.FaultExceptionMapperBase {
        
        public override System.Web.Services.Protocols.SoapException LookupAndCreateException(System.Web.Services.Protocols.SoapException ex) {
            System.Xml.XmlQualifiedName qualifiedDetailName;
            if (((ex.Detail != null) 
                        && ex.Detail.HasChildNodes)) {
                qualifiedDetailName = new System.Xml.XmlQualifiedName(ex.Detail.FirstChild.LocalName, ex.Detail.FirstChild.NamespaceURI);
            }
            else {
                return null;
            }
            if (((qualifiedDetailName.Namespace == "http://htng.org/PSWG/06/04/Samples/Math/Faults") 
                        && (qualifiedDetailName.Name == "ArithmeticOverflowFault"))) {
                return new ArithmeticOverflowFaultException(ex.Message, ex.Code, ex.Actor, ex.Detail);
            }
            if (((qualifiedDetailName.Namespace == "http://htng.org/PSWG/06/04/Samples/Math/Faults") 
                        && (qualifiedDetailName.Name == "DivideByZeroFault"))) {
                return new DivideByZeroFaultException(ex.Message, ex.Code, ex.Actor, ex.Detail);
            }
            return null;
        }
    }
}
