using System;
using System.Xml;

using Microsoft.Web.Services3;
using Microsoft.Web.Services3.Security;
using Microsoft.Web.Services3.Security.Tokens;

namespace HTNG.Web.Services2.Security
{
    /// <summary>
    /// Custom UserNameTokenManager used to provide a framework
    /// for non-traditional authentication of plain text username 
    /// and password pairs provided as part of WS-Security SOAP header. 
    /// The UsernameTokenManager base method VerifyToken is called once
    /// for each SecurityToken of type UsernameToken passed in the
    /// header.  VerifyToken will calls overridden method AuthenticateToken.
    /// Developers should insert code into this method to retrieve what
    /// <i>should</i> be the correct password for the user specified.  The
    /// WSE 3.0 will subsequently compare the value returned by AuthenticateToken
    /// to the value provided in the token to make an assesment as to the
    /// validity of the login request.  If a valid password cannot be retrieved
    /// for the user specified (i.e. invalid username), then an exception
    /// for type "SecurityFault" should be raised in the overridden 
    /// AuthenticateToken method.
    /// </summary>
    public class HTNGBaseUsernameTokenManager : UsernameTokenManager
    {
        /// <summary>
        /// AuthenticateToken should return the "authenticated" or correct password for 
        /// the token provided. If a password cannot be retrieved by your
        /// custom code, an exception of type "SecurityFault" should be thrown. Note
        /// that you may provide as little or as much detail as you like in the 
        /// SecurityFault exception.  As a general rule, your should provide the
        /// bare minimum of amplifying information required to convey that the
        /// login has failed.  Just as an example, if you reply with "The username INVALID
        /// provided cannot be found in our SQL server database located and connection
        /// string xxxx", you are providing <i>way</i> to much guidance to the bad
        /// guys on how to proceed with the exploitation of your web service implementation.
        /// </summary>
        /// <param name="token">The UsernameToken to authenticate.</param>
        /// <returns>The password of the authenticated UsernameToken.</returns>
        protected override string AuthenticateToken(UsernameToken token)
        {
            if (token.Username == "INVALID")
                throw new SecurityFault("Access Denied");
            return token.Password;
        }
   }
}