//
// Written by Aaron Skonnard (aaron@pluralsight.com)
// Blog: http://pluralsight.com/aaron/ 
//

using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Web.Services3.Messaging;

namespace Microsoft.Samples.HttpSys
{
    //
    // When you add an ASMX class to SoapReceivers, it holds it in a WebServiceReceiver
    // object. WebServiceReceiver provides the functionality for automatically producing
    // WSDL for the target ASMX class, but the methods aren't public. Hence, this
    // class, WsdlEnabledReceiver, which provides a public GetDescription method. This
    // can be used from within the HttpSysAdapter to return WSDL when requested via GET.
    //
    // If you want to support WSDL, you need to wrap your ASMX type in an instance of 
    // WsdlEnabledReceiver when calling SoapReceivers.Add.
    //
    public class WsdlEnabledReceiver : WebServiceReceiver
    {
        public WsdlEnabledReceiver(object o) : base(o) { }
        public WsdlEnabledReceiver(Type t) : base(t) { }

        public new System.Web.Services.Description.ServiceDescription GetDescription(Uri location)
        {
            return base.GetDescription(location);
        }
    }
}
