using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;

using Faults = Contract.Service.Faults;

[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class Service : System.Web.Services.WebService, Contract.Service.IMathServiceSoap
{
    public Service () 
    {
    }

    public int Add(int a, int b)
    {
        try
        {
            return checked(a + b);
        }
        catch (OverflowException)
        {
            Faults.ArithmeticOverflowFault faultDetail =
                new Faults.ArithmeticOverflowFault();

            faultDetail.LowerBound = int.MinValue.ToString();
            faultDetail.UpperBound = int.MaxValue.ToString();

            throw new Faults.ArithmeticOverflowFaultException(
                SoapException.ClientFaultCode,
                faultDetail);
        }
    }

    public double Divide(int a, int b)
    {
        if (b == 0)
            throw new Faults.DivideByZeroFaultException(
                SoapException.ClientFaultCode,
                new Faults.DivideByZeroFault());

        return a / b;
    }

    public int Subtract(int a, int b)
    {
        throw new Exception("The method or operation is not implemented.");
    }

    public int Multiply(int a, int b)
    {
        throw new Exception("The method or operation is not implemented.");
    }


}
