using System;
using System.ComponentModel;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Xml.Serialization;
using System.Xml;
using Microsoft.Web.Services3;

[WebService(Namespace = "http://htng.org/PWSWG/2006/04/SingleGuestItinerary")]
// the following applies a custom policy that will require the presence of
// the UsernameToken (WS-Security) and Action (WS-Addressing) headers in SOAP requests
[Policy(typeof(ActivityServicePolicy))]
public class ActivityService : IReservationProviderBinding   
{
  public ActivityService():base() {}

  #region IReservationProviderBinding Members

  public pmtpostingresults PostPayment(pmtpostingupdate pmtpostingupdate)
  {
    //put your request processing code here .......

    double tips = 0;
    double pmtAmt = 0;
    double totalAmt = 0;

    // some conversion has to be done due to the fields 
    // having been declared as "xs:integer" in the schema,
    // which results in auto-generated fields of type "string"
    totalAmt += pmtAmt = pmtpostingupdate.PaymentAmount / 100;

    totalAmt += tips = pmtpostingupdate.TipAmount / 100;

    if (tips > pmtAmt * 0.2)
      throw new ApplicationException("Tip amount excessive");

    pmtpostingresults result = new pmtpostingresults();

    result.PaymentAmount = (int) (totalAmt * 100);

    result.PostingGUID = Guid.NewGuid().ToString();
    result.Status = new ResultStatus();
    result.Status.code = "0";
    result.Status.resultStatusFlag = ResultStatusFlag.SUCCESS;
    result.Status.resultStatusFlagSpecified = true;
    return result;
  }

  #endregion
}

